/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Set;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.interfaces.XMSSMTPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXMSSMTPrivateKey
implements PrivateKey,
XMSSMTPrivateKey {
    private static final long serialVersionUID = 7682140473044521395L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier treeDigest, XMSSMTPrivateKeyParameters keyParams) {
        this.treeDigest = treeDigest;
        this.keyParams = keyParams;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        XMSSMTKeyParams keyParams = XMSSMTKeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = keyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSMTPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    @Override
    public long getUsagesRemaining() {
        return this.keyParams.getUsagesRemaining();
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey otherKey = (BCXMSSMTPrivateKey)o;
            return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), otherKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

