/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.newhope;

import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.interfaces.NHPublicKey;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCNHPublicKey
implements NHPublicKey {
    private static final long serialVersionUID = 1L;
    private transient NHPublicKeyParameters params;

    public BCNHPublicKey(NHPublicKeyParameters params) {
        this.params = params;
    }

    public BCNHPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (NHPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey otherKey = (BCNHPublicKey)o;
        return Arrays.areEqual(this.params.getPubData(), otherKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.params.getPubData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

