/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss;

import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSOid;

public final class XMSSParameters {
    private final XMSSOid oid;
    private final WOTSPlus wotsPlus;
    private final int height;
    private final int k;

    public XMSSParameters(int height, Digest digest) {
        if (height < 2) {
            throw new IllegalArgumentException("height must be >= 2");
        }
        if (digest == null) {
            throw new NullPointerException("digest == null");
        }
        this.wotsPlus = new WOTSPlus(new WOTSPlusParameters(digest));
        this.height = height;
        this.k = this.determineMinK();
        this.oid = DefaultXMSSOid.lookup(this.getDigest().getAlgorithmName(), this.getDigestSize(), this.getWinternitzParameter(), this.wotsPlus.getParams().getLen(), height);
    }

    private int determineMinK() {
        for (int k = 2; k <= this.height; ++k) {
            if ((this.height - k) % 2 != 0) continue;
            return k;
        }
        throw new IllegalStateException("should never happen...");
    }

    protected Digest getDigest() {
        return this.wotsPlus.getParams().getDigest();
    }

    public int getDigestSize() {
        return this.wotsPlus.getParams().getDigestSize();
    }

    public int getWinternitzParameter() {
        return this.wotsPlus.getParams().getWinternitzParameter();
    }

    public int getHeight() {
        return this.height;
    }

    WOTSPlus getWOTSPlus() {
        return this.wotsPlus;
    }

    XMSSOid getOid() {
        return this.oid;
    }

    int getK() {
        return this.k;
    }
}

