/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.util;

import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.Utils;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof QTESLAPublicKeyParameters) {
            QTESLAPublicKeyParameters keyParams = (QTESLAPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(keyParams.getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, keyParams.getPublicData());
        }
        if (publicKey instanceof SPHINCSPublicKeyParameters) {
            SPHINCSPublicKeyParameters params = (SPHINCSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(params.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getKeyData());
        }
        if (publicKey instanceof NHPublicKeyParameters) {
            NHPublicKeyParameters params = (NHPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getPubData());
        }
        if (publicKey instanceof XMSSPublicKeyParameters) {
            XMSSPublicKeyParameters keyParams = (XMSSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(keyParams.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(keyParams.getPublicSeed(), keyParams.getRoot()));
        }
        if (publicKey instanceof XMSSMTPublicKeyParameters) {
            XMSSMTPublicKeyParameters keyParams = (XMSSMTPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(keyParams.getParameters().getHeight(), keyParams.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(keyParams.getPublicSeed(), keyParams.getRoot()));
        }
        throw new IOException("key parameters not recognized");
    }
}

