/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.util;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1InputStream;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.Utils;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.BDS;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.icbc.bcprov.org.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algOID = algId.getAlgorithm();
        if (algOID.on(BCObjectIdentifiers.qTESLA)) {
            ASN1OctetString qTESLAPriv = ASN1OctetString.getInstance(keyInfo.parsePrivateKey());
            return new QTESLAPrivateKeyParameters(Utils.qTeslaLookupSecurityCategory(keyInfo.getPrivateKeyAlgorithm()), qTESLAPriv.getOctets());
        }
        if (algOID.equals(BCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters())));
        }
        if (algOID.equals(BCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.convert(ASN1OctetString.getInstance(keyInfo.parsePrivateKey()).getOctets()));
        }
        if (algOID.equals(BCObjectIdentifiers.xmss)) {
            XMSSKeyParams keyParams = XMSSKeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
            XMSSPrivateKey xmssPrivateKey = XMSSPrivateKey.getInstance(keyInfo.parsePrivateKey());
            try {
                XMSSPrivateKeyParameters.Builder keyBuilder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(keyParams.getHeight(), Utils.getDigest(treeDigest))).withIndex(xmssPrivateKey.getIndex()).withSecretKeySeed(xmssPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssPrivateKey.getPublicSeed()).withRoot(xmssPrivateKey.getRoot());
                if (xmssPrivateKey.getBdsState() != null) {
                    BDS bds = (BDS)XMSSUtil.deserialize(xmssPrivateKey.getBdsState(), BDS.class);
                    keyBuilder.withBDSState(bds.withWOTSDigest(treeDigest));
                }
                return keyBuilder.build();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("ClassNotFoundException processing BDS state: " + e.getMessage());
            }
        }
        if (algOID.equals(PQCObjectIdentifiers.xmss_mt)) {
            XMSSMTKeyParams keyParams = XMSSMTKeyParams.getInstance(keyInfo.getPrivateKeyAlgorithm().getParameters());
            ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
            try {
                XMSSPrivateKey xmssMtPrivateKey = XMSSPrivateKey.getInstance(keyInfo.parsePrivateKey());
                XMSSMTPrivateKeyParameters.Builder keyBuilder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(keyParams.getHeight(), keyParams.getLayers(), Utils.getDigest(treeDigest))).withIndex(xmssMtPrivateKey.getIndex()).withSecretKeySeed(xmssMtPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xmssMtPrivateKey.getSecretKeyPRF()).withPublicSeed(xmssMtPrivateKey.getPublicSeed()).withRoot(xmssMtPrivateKey.getRoot());
                if (xmssMtPrivateKey.getBdsState() != null) {
                    BDSStateMap bdsState = (BDSStateMap)XMSSUtil.deserialize(xmssMtPrivateKey.getBdsState(), BDSStateMap.class);
                    keyBuilder.withBDSState(bdsState.withWOTSDigest(treeDigest));
                }
                return keyBuilder.build();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("ClassNotFoundException processing BDS state: " + e.getMessage());
            }
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static short[] convert(byte[] octets) {
        short[] rv = new short[octets.length / 2];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Pack.littleEndianToShort(octets, i * 2);
        }
        return rv;
    }
}

