/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.gmss;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.gmss.GMSSSigner;
import com.icbc.bcprov.org.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner gmssSigner;
    private GMSSPrivateKeyParameters key;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable dig = ((Memoable)((Object)digest)).copy();
        this.gmssSigner = new GMSSSigner(new GMSSDigestProvider(){

            @Override
            public Digest get() {
                return (Digest)((Object)dig.copy());
            }
        });
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (GMSSPrivateKeyParameters)rParam.getParameters();
            } else {
                this.key = (GMSSPrivateKeyParameters)param;
            }
        }
        this.gmssSigner.init(forSigning, param);
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        if (this.key == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] sig = this.gmssSigner.generateSignature(message);
        this.key = this.key.nextKey();
        return sig;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        return this.gmssSigner.verifySignature(message, signature);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters k = this.key;
        this.key = null;
        return k;
    }
}

