/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jce.provider;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.PBEParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithIV;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.icbc.bcprov.org.bouncycastle.jce.provider.OldPKCS12ParametersGenerator;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public interface BrokenPBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OLD_PKCS12 = 3;

    public static class Util {
        private static void setOddParity(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                bytes[i] = (byte)(b & 0xFE | b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7 ^ 1);
            }
        }

        private static PBEParametersGenerator makePBEGenerator(int type, int hash) {
            PBEParametersGenerator generator;
            block15: {
                block17: {
                    block16: {
                        block14: {
                            if (type != 0) break block14;
                            switch (hash) {
                                case 0: {
                                    generator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block15;
                                }
                                case 1: {
                                    generator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block15;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports only MD5 and SHA1.");
                                }
                            }
                        }
                        if (type != 1) break block16;
                        generator = new PKCS5S2ParametersGenerator();
                        break block15;
                    }
                    if (type != 3) break block17;
                    switch (hash) {
                        case 0: {
                            generator = new OldPKCS12ParametersGenerator(new MD5Digest());
                            break block15;
                        }
                        case 1: {
                            generator = new OldPKCS12ParametersGenerator(new SHA1Digest());
                            break block15;
                        }
                        case 2: {
                            generator = new OldPKCS12ParametersGenerator(new RIPEMD160Digest());
                            break block15;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                switch (hash) {
                    case 0: {
                        generator = new PKCS12ParametersGenerator(new MD5Digest());
                        break;
                    }
                    case 1: {
                        generator = new PKCS12ParametersGenerator(new SHA1Digest());
                        break;
                    }
                    case 2: {
                        generator = new PKCS12ParametersGenerator(new RIPEMD160Digest());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                    }
                }
            }
            return generator;
        }

        static CipherParameters makePBEParameters(BCPBEKey pbeKey, AlgorithmParameterSpec spec, int type, int hash, String targetAlgorithm, int keySize, int ivSize) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = pbeKey.getEncoded();
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
            if (targetAlgorithm.startsWith("DES")) {
                KeyParameter kParam;
                if (param instanceof ParametersWithIV) {
                    kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                    Util.setOddParity(kParam.getKey());
                } else {
                    kParam = (KeyParameter)param;
                    Util.setOddParity(kParam.getKey());
                }
            }
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        static CipherParameters makePBEMacParameters(BCPBEKey pbeKey, AlgorithmParameterSpec spec, int type, int hash, int keySize) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = pbeKey.getEncoded();
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }
    }
}

