/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.util;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X962Parameters;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ec.CustomNamedCurves;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.icbc.bcprov.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.icbc.bcprov.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.icbc.bcprov.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.icbc.bcprov.org.bouncycastle.jce.spec.ECParameterSpec;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECAlgorithms;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.field.FiniteField;
import com.icbc.bcprov.org.bouncycastle.math.field.Polynomial;
import com.icbc.bcprov.org.bouncycastle.math.field.PolynomialExtensionField;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EC5Util {
    private static Map customCurves = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECCurve getCurve(ProviderConfiguration configuration, X962Parameters params) {
        Set acceptableCurves = configuration.getAcceptableNamedCurves();
        if (params.isNamedCurve()) {
            X9ECParameters ecP;
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
            if (!acceptableCurves.isEmpty()) {
                if (!acceptableCurves.contains(oid)) throw new IllegalStateException("named curve not acceptable");
            }
            if ((ecP = ECUtil.getNamedCurveByOid(oid)) != null) return ecP.getCurve();
            ecP = (X9ECParameters)configuration.getAdditionalECParameters().get(oid);
            return ecP.getCurve();
        }
        if (params.isImplicitlyCA()) {
            return configuration.getEcImplicitlyCa().getCurve();
        }
        if (!acceptableCurves.isEmpty()) throw new IllegalStateException("encoded parameters not acceptable");
        X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
        return ecP.getCurve();
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration configuration, java.security.spec.ECParameterSpec params) {
        ECDomainParameters domainParameters;
        if (params == null) {
            ECParameterSpec iSpec = configuration.getEcImplicitlyCa();
            domainParameters = new ECDomainParameters(iSpec.getCurve(), iSpec.getG(), iSpec.getN(), iSpec.getH(), iSpec.getSeed());
        } else {
            domainParameters = ECUtil.getDomainParameters(configuration, EC5Util.convertSpec(params, false));
        }
        return domainParameters;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X962Parameters params, ECCurve curve) {
        java.security.spec.ECParameterSpec ecSpec;
        if (params.isNamedCurve()) {
            Map additionalECParameters;
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
            X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
            if (ecP == null && !(additionalECParameters = BouncyCastleProvider.CONFIGURATION.getAdditionalECParameters()).isEmpty()) {
                ecP = (X9ECParameters)additionalECParameters.get(oid);
            }
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
            ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName(oid), ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH());
        } else if (params.isImplicitlyCA()) {
            ecSpec = null;
        } else {
            X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
            ecSpec = ecP.getH() != null ? new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH().intValue()) : new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), 1);
        }
        return ecSpec;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X9ECParameters domainParameters) {
        return new java.security.spec.ECParameterSpec(EC5Util.convertCurve(domainParameters.getCurve(), null), EC5Util.convertPoint(domainParameters.getG()), domainParameters.getN(), domainParameters.getH().intValue());
    }

    public static java.security.spec.ECParameterSpec convertToSpec(ECDomainParameters domainParameters) {
        return new java.security.spec.ECParameterSpec(EC5Util.convertCurve(domainParameters.getCurve(), null), EC5Util.convertPoint(domainParameters.getG()), domainParameters.getN(), domainParameters.getH().intValue());
    }

    public static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        ECField field = EC5Util.convertField(curve.getField());
        BigInteger a = curve.getA().toBigInteger();
        BigInteger b = curve.getB().toBigInteger();
        return new EllipticCurve(field, a, b, null);
    }

    public static ECCurve convertCurve(EllipticCurve ec) {
        ECField field = ec.getField();
        BigInteger a = ec.getA();
        BigInteger b = ec.getB();
        if (field instanceof ECFieldFp) {
            ECCurve.Fp curve = new ECCurve.Fp(((ECFieldFp)field).getP(), a, b);
            if (customCurves.containsKey(curve)) {
                return (ECCurve)customCurves.get(curve);
            }
            return curve;
        }
        ECFieldF2m fieldF2m = (ECFieldF2m)field;
        int m = fieldF2m.getM();
        int[] ks = ECUtil.convertMidTerms(fieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(m, ks[0], ks[1], ks[2], a, b);
    }

    public static ECField convertField(FiniteField field) {
        if (ECAlgorithms.isFpField(field)) {
            return new ECFieldFp(field.getCharacteristic());
        }
        Polynomial poly = ((PolynomialExtensionField)field).getMinimalPolynomial();
        int[] exponents = poly.getExponentsPresent();
        int[] ks = Arrays.reverse(Arrays.copyOfRange(exponents, 1, exponents.length - 1));
        return new ECFieldF2m(poly.getDegree(), ks);
    }

    public static java.security.spec.ECParameterSpec convertSpec(EllipticCurve ellipticCurve, ECParameterSpec spec) {
        if (spec instanceof ECNamedCurveParameterSpec) {
            return new ECNamedCurveSpec(((ECNamedCurveParameterSpec)spec).getName(), ellipticCurve, EC5Util.convertPoint(spec.getG()), spec.getN(), spec.getH());
        }
        return new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(spec.getG()), spec.getN(), spec.getH().intValue());
    }

    public static ECParameterSpec convertSpec(java.security.spec.ECParameterSpec ecSpec, boolean withCompression) {
        ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
        if (ecSpec instanceof ECNamedCurveSpec) {
            return new ECNamedCurveParameterSpec(((ECNamedCurveSpec)ecSpec).getName(), curve, EC5Util.convertPoint(curve, ecSpec.getGenerator(), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
        }
        return new ECParameterSpec(curve, EC5Util.convertPoint(curve, ecSpec.getGenerator(), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
    }

    public static com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint convertPoint(java.security.spec.ECParameterSpec ecSpec, ECPoint point, boolean withCompression) {
        return EC5Util.convertPoint(EC5Util.convertCurve(ecSpec.getCurve()), point, withCompression);
    }

    public static com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint convertPoint(ECCurve curve, ECPoint point, boolean withCompression) {
        return curve.createPoint(point.getAffineX(), point.getAffineY());
    }

    public static ECPoint convertPoint(com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint point) {
        point = point.normalize();
        return new ECPoint(point.getAffineXCoord().toBigInteger(), point.getAffineYCoord().toBigInteger());
    }

    static {
        Enumeration e = CustomNamedCurves.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            X9ECParameters curveParams = ECNamedCurveTable.getByName(name);
            if (curveParams == null) continue;
            customCurves.put(curveParams.getCurve(), CustomNamedCurves.getByName(name).getCurve());
        }
        X9ECParameters x9_25519 = CustomNamedCurves.getByName("Curve25519");
        ECCurve c_25519 = x9_25519.getCurve();
        customCurves.put(new ECCurve.Fp(c_25519.getField().getCharacteristic(), c_25519.getA().toBigInteger(), c_25519.getB().toBigInteger(), c_25519.getOrder(), c_25519.getCofactor()), c_25519);
    }
}

