/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Encodable;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Set;
import com.icbc.bcprov.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.jcajce.interfaces.XDHKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCXDHPrivateKey
implements XDHKey,
PrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricKeyParameter xdhPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    BCXDHPrivateKey(AsymmetricKeyParameter privKey) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.xdhPrivateKey = privKey;
    }

    BCXDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.hasPublicKey = keyInfo.hasPublicKey();
        this.attributes = keyInfo.getAttributes() != null ? keyInfo.getAttributes().getEncoded() : null;
        this.populateFromPrivateKeyInfo(keyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo keyInfo) throws IOException {
        ASN1Encodable keyOcts = keyInfo.parsePrivateKey();
        this.xdhPrivateKey = EdECObjectIdentifiers.id_X448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new X448PrivateKeyParameters(ASN1OctetString.getInstance(keyOcts).getOctets(), 0) : new X25519PrivateKeyParameters(ASN1OctetString.getInstance(keyOcts).getOctets(), 0);
    }

    @Override
    public String getAlgorithm() {
        return this.xdhPrivateKey instanceof X448PrivateKeyParameters ? "X448" : "X25519";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ASN1Set attrSet = ASN1Set.getInstance(this.attributes);
            PrivateKeyInfo privInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.xdhPrivateKey, attrSet);
            if (this.hasPublicKey) {
                return privInfo.getEncoded();
            }
            return new PrivateKeyInfo(privInfo.getPrivateKeyAlgorithm(), privInfo.parsePrivateKey(), attrSet).getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.xdhPrivateKey;
    }

    public String toString() {
        AsymmetricKeyParameter pubKey = this.xdhPrivateKey instanceof X448PrivateKeyParameters ? ((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey() : ((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BCXDHPrivateKey)) {
            return false;
        }
        BCXDHPrivateKey other = (BCXDHPrivateKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

