/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.util;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERTaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.sec.ECPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DSAParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.icbc.bcprov.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.crypto.util.SSHBuffer;
import com.icbc.bcprov.org.bouncycastle.crypto.util.SSHBuilder;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.bcprov.org.bouncycastle.util.BigIntegers;
import com.icbc.bcprov.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (params instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof DSAPrivateKeyParameters) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add(new ASN1Integer(0L));
            vec.add(new ASN1Integer(((DSAPrivateKeyParameters)params).getParameters().getP()));
            vec.add(new ASN1Integer(((DSAPrivateKeyParameters)params).getParameters().getQ()));
            vec.add(new ASN1Integer(((DSAPrivateKeyParameters)params).getParameters().getG()));
            BigInteger pubKey = ((DSAPrivateKeyParameters)params).getParameters().getG().modPow(((DSAPrivateKeyParameters)params).getX(), ((DSAPrivateKeyParameters)params).getParameters().getP());
            vec.add(new ASN1Integer(pubKey));
            vec.add(new ASN1Integer(((DSAPrivateKeyParameters)params).getX()));
            try {
                return new DERSequence(vec).getEncoded();
            }
            catch (Exception ex) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + ex.getMessage());
            }
        }
        if (params instanceof Ed25519PrivateKeyParameters) {
            SSHBuilder builder = new SSHBuilder();
            builder.write(AUTH_MAGIC);
            builder.writeString("none");
            builder.writeString("none");
            builder.u32(0L);
            builder.u32(1L);
            Ed25519PublicKeyParameters publicKeyParameters = ((Ed25519PrivateKeyParameters)params).generatePublicKey();
            byte[] pkEncoded = OpenSSHPublicKeyUtil.encodePublicKey(publicKeyParameters);
            builder.rawArray(pkEncoded);
            SSHBuilder pkBuild = new SSHBuilder();
            pkBuild.u32(0xFF00FFL);
            pkBuild.u32(0xFF00FFL);
            pkBuild.writeString("ssh-ed25519");
            byte[] pubKeyEncoded = ((Ed25519PrivateKeyParameters)params).generatePublicKey().getEncoded();
            pkBuild.rawArray(pubKeyEncoded);
            pkBuild.rawArray(Arrays.concatenate(((Ed25519PrivateKeyParameters)params).getEncoded(), pubKeyEncoded));
            pkBuild.u32(0L);
            builder.rawArray(pkBuild.getBytes());
            return builder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + params.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] blob) {
        AsymmetricKeyParameter result = null;
        if (blob[0] == 48) {
            ASN1Sequence sequence = ASN1Sequence.getInstance(blob);
            if (sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    result = new DSAPrivateKeyParameters(((ASN1Integer)sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance(sequence);
                    result = new RSAPrivateCrtKeyParameters(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
                }
            } else if (sequence.size() == 4 && sequence.getObjectAt(3) instanceof DERTaggedObject && sequence.getObjectAt(2) instanceof DERTaggedObject) {
                ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance(sequence);
                ASN1ObjectIdentifier curveOID = (ASN1ObjectIdentifier)ecPrivateKey.getParameters();
                X9ECParameters x9Params = ECNamedCurveTable.getByOID(curveOID);
                result = new ECPrivateKeyParameters(ecPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(curveOID, x9Params.getCurve(), x9Params.getG(), x9Params.getN(), x9Params.getH(), x9Params.getSeed()));
            }
        } else {
            int check2;
            SSHBuffer kIn = new SSHBuffer(AUTH_MAGIC, blob);
            String cipherName = Strings.fromByteArray(kIn.readString());
            if (!"none".equals(cipherName)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            kIn.readString();
            kIn.readString();
            long publicKeyCount = kIn.readU32();
            int l = 0;
            while ((long)l != publicKeyCount) {
                OpenSSHPublicKeyUtil.parsePublicKey(kIn.readString());
                ++l;
            }
            SSHBuffer pkIn = new SSHBuffer(kIn.readPaddedString());
            int check1 = pkIn.readU32();
            if (check1 != (check2 = pkIn.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String keyType = Strings.fromByteArray(pkIn.readString());
            if ("ssh-ed25519".equals(keyType)) {
                pkIn.readString();
                byte[] edPrivateKey = pkIn.readString();
                result = new Ed25519PrivateKeyParameters(edPrivateKey, 0);
            } else {
                throw new IllegalStateException("can not parse private key of type " + keyType);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return result;
    }

    private static boolean allIntegers(ASN1Sequence sequence) {
        for (int t = 0; t < sequence.size(); ++t) {
            if (sequence.getObjectAt(t) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

