/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.tls;

import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.LongDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.HMac;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.SSL3Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsContext;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsUtils;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsMac(TlsContext context, Digest digest, byte[] key, int keyOff, int keyLen) {
        this.context = context;
        KeyParameter keyParameter = new KeyParameter(key, keyOff, keyLen);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (TlsUtils.isSSL(context)) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
        this.macLength = this.mac.getMacSize();
        if (context.getSecurityParameters().truncatedHMac) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.macLength;
    }

    public byte[] calculateMac(long seqNo, short type, byte[] message, int offset, int length) {
        ProtocolVersion serverVersion = this.context.getServerVersion();
        boolean isSSL = serverVersion.isSSL();
        byte[] macHeader = new byte[isSSL ? 11 : 13];
        TlsUtils.writeUint64(seqNo, macHeader, 0);
        TlsUtils.writeUint8(type, macHeader, 8);
        if (!isSSL) {
            TlsUtils.writeVersion(serverVersion, macHeader, 9);
        }
        TlsUtils.writeUint16(length, macHeader, macHeader.length - 2);
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, length);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return this.truncate(result);
    }

    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] message, int offset, int length, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, message, offset, length);
        int headerLength = TlsUtils.isSSL(this.context) ? 11 : 13;
        int extra = this.getDigestBlockCount(headerLength + fullLength) - this.getDigestBlockCount(headerLength + length);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData[0]);
        this.mac.reset();
        return result;
    }

    protected int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] bs) {
        if (bs.length <= this.macLength) {
            return bs;
        }
        return Arrays.copyOf(bs, this.macLength);
    }
}

