/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.tls;

import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.Signer;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.DefaultTlsDHVerifier;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.DigestInputBuffer;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.DigitallySigned;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.SecurityParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.SignerInputBuffer;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsCredentials;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsDHUtils;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsDHVerifier;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsUtils;
import com.icbc.bcprov.org.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        this(keyExchange, supportedSignatureAlgorithms, new DefaultTlsDHVerifier(), dhParameters);
    }

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHVerifier dhVerifier, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms, dhVerifier, dhParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer buf = new DigestInputBuffer();
        this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, buf);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest d = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(d);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
        DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
        signed_params.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = new SignerInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        this.dhParameters = TlsDHUtils.receiveDHParameters(this.dhVerifier, teeIn);
        this.dhAgreePublicKey = new DHPublicKeyParameters(TlsDHUtils.readDHParameter(teeIn), this.dhParameters);
        DigitallySigned signed_params = this.parseSignature(input);
        Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
        buf.updateSigner(signer);
        if (!signer.verifySignature(signed_params.getSignature())) {
            throw new TlsFatalAlert(51);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

