/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.tls;

import com.icbc.bcprov.org.bouncycastle.crypto.agreement.DHStandardGroups;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.tls.TlsDHVerifier;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsDHVerifier
implements TlsDHVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHParameters dhParameters) {
        DEFAULT_GROUPS.addElement(dhParameters);
    }

    public DefaultTlsDHVerifier() {
        this(2048);
    }

    public DefaultTlsDHVerifier(int minimumPrimeBits) {
        this(DEFAULT_GROUPS, minimumPrimeBits);
    }

    public DefaultTlsDHVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = groups;
        this.minimumPrimeBits = minimumPrimeBits;
    }

    @Override
    public boolean accept(DHParameters dhParameters) {
        return this.checkMinimumPrimeBits(dhParameters) && this.checkGroup(dhParameters);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHParameters a, DHParameters b) {
        return a == b || this.areParametersEqual(a.getP(), b.getP()) && this.areParametersEqual(a.getG(), b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    protected boolean checkGroup(DHParameters dhParameters) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dhParameters, (DHParameters)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(DHParameters dhParameters) {
        return dhParameters.getP().bitLength() >= this.getMinimumPrimeBits();
    }

    static {
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
    }
}

