/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.params;

import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.rfc8032.Ed25519;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.bcprov.org.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final byte[] data = new byte[32];

    public Ed25519PrivateKeyParameters(SecureRandom random) {
        super(true);
        Ed25519.generatePrivateKey(random, this.data);
    }

    public Ed25519PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.data, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (32 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] publicKey = new byte[32];
        Ed25519.generatePublicKey(this.data, 0, publicKey, 0);
        return new Ed25519PublicKeyParameters(publicKey, 0);
    }

    public void sign(int algorithm, Ed25519PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        byte[] pk = new byte[32];
        if (null == publicKey) {
            Ed25519.generatePublicKey(this.data, 0, pk, 0);
        } else {
            publicKey.encode(pk, 0);
        }
        switch (algorithm) {
            case 0: {
                if (null != ctx) {
                    throw new IllegalArgumentException("ctx");
                }
                Ed25519.sign(this.data, 0, pk, 0, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                Ed25519.sign(this.data, 0, pk, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 2: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                Ed25519.signPrehash(this.data, 0, pk, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

