/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.generators;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.GOST3410Parameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.WNafUtil;
import com.icbc.bcprov.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GOST3410KeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (GOST3410KeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        GOST3410Parameters GOST3410Params2 = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = GOST3410Params2.getQ();
        BigInteger p = GOST3410Params2.getP();
        BigInteger a = GOST3410Params2.getA();
        int minWeight = 64;
        while ((x = BigIntegers.createRandomBigInteger(256, random)).signum() < 1 || x.compareTo(q) >= 0 || WNafUtil.getNafWeight(x) < minWeight) {
        }
        BigInteger y = a.modPow(x, p);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(y, GOST3410Params2), new GOST3410PrivateKeyParameters(x, GOST3410Params2));
    }
}

