/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.generators;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ElGamalParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

