/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.generators;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

