/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.ec;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.icbc.bcprov.org.bouncycastle.crypto.ec.ECPair;
import com.icbc.bcprov.org.bouncycastle.crypto.ec.ECPairTransform;
import com.icbc.bcprov.org.bouncycastle.crypto.ec.ECUtil;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECAlgorithms;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECMultiplier;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewPublicKeyTransform
implements ECPairTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            if (!(p.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)p.getParameters();
            this.random = p.getRandom();
        } else {
            if (!(param instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)param;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewPublicKeyTransform not initialised");
        }
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        BigInteger k = ECUtil.generateK(n, this.random);
        ECPoint[] gamma_phi = new ECPoint[]{basePointMultiplier.multiply(ec.getG(), k), this.key.getQ().multiply(k).add(ECAlgorithms.cleanPoint(ec.getCurve(), cipherText.getY()))};
        ec.getCurve().normalizeAll(gamma_phi);
        return new ECPair(gamma_phi[0], gamma_phi[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

