/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.agreement;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.RawAgreement;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X25519PublicKeyParameters;

public final class X25519Agreement
implements RawAgreement {
    private X25519PrivateKeyParameters privateKey;

    @Override
    public void init(CipherParameters parameters) {
        this.privateKey = (X25519PrivateKeyParameters)parameters;
    }

    @Override
    public int getAgreementSize() {
        return 32;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        this.privateKey.generateSecret((X25519PublicKeyParameters)publicKey, buf, off);
    }
}

