/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.x9;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1TaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERTaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.KeySpecificInfo;
import java.util.Enumeration;

public class OtherInfo
extends ASN1Object {
    private KeySpecificInfo keyInfo;
    private ASN1OctetString partyAInfo;
    private ASN1OctetString suppPubInfo;

    public OtherInfo(KeySpecificInfo keyInfo, ASN1OctetString partyAInfo, ASN1OctetString suppPubInfo) {
        this.keyInfo = keyInfo;
        this.partyAInfo = partyAInfo;
        this.suppPubInfo = suppPubInfo;
    }

    public static OtherInfo getInstance(Object obj) {
        if (obj instanceof OtherInfo) {
            return (OtherInfo)obj;
        }
        if (obj != null) {
            return new OtherInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private OtherInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.keyInfo = KeySpecificInfo.getInstance(e.nextElement());
        while (e.hasMoreElements()) {
            ASN1TaggedObject o = (ASN1TaggedObject)e.nextElement();
            if (o.getTagNo() == 0) {
                this.partyAInfo = (ASN1OctetString)o.getObject();
                continue;
            }
            if (o.getTagNo() != 2) continue;
            this.suppPubInfo = (ASN1OctetString)o.getObject();
        }
    }

    public KeySpecificInfo getKeyInfo() {
        return this.keyInfo;
    }

    public ASN1OctetString getPartyAInfo() {
        return this.partyAInfo;
    }

    public ASN1OctetString getSuppPubInfo() {
        return this.suppPubInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.keyInfo);
        if (this.partyAInfo != null) {
            v.add(new DERTaggedObject(0, this.partyAInfo));
        }
        v.add(new DERTaggedObject(2, this.suppPubInfo));
        return new DERSequence(v);
    }
}

