/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.x509;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1TaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.Extension;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.Extensions;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] policyInformation;

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificatePolicies fromExtensions(Extensions extensions) {
        return CertificatePolicies.getInstance(extensions.getExtensionParsedValue(Extension.certificatePolicies));
    }

    public CertificatePolicies(PolicyInformation name) {
        this.policyInformation = new PolicyInformation[]{name};
    }

    public CertificatePolicies(PolicyInformation[] policyInformation) {
        this.policyInformation = this.copyPolicyInfo(policyInformation);
    }

    private CertificatePolicies(ASN1Sequence seq) {
        this.policyInformation = new PolicyInformation[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            this.policyInformation[i] = PolicyInformation.getInstance(seq.getObjectAt(i));
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        return this.copyPolicyInfo(this.policyInformation);
    }

    private PolicyInformation[] copyPolicyInfo(PolicyInformation[] policyInfo) {
        PolicyInformation[] tmp = new PolicyInformation[policyInfo.length];
        System.arraycopy(policyInfo, 0, tmp, 0, policyInfo.length);
        return tmp;
    }

    public PolicyInformation getPolicyInformation(ASN1ObjectIdentifier policyIdentifier) {
        for (int i = 0; i != this.policyInformation.length; ++i) {
            if (!policyIdentifier.equals(this.policyInformation[i].getPolicyIdentifier())) continue;
            return this.policyInformation[i];
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.policyInformation);
    }

    public String toString() {
        StringBuffer p = new StringBuffer();
        for (int i = 0; i < this.policyInformation.length; ++i) {
            if (p.length() != 0) {
                p.append(", ");
            }
            p.append(this.policyInformation[i]);
        }
        return "CertificatePolicies: [" + p + "]";
    }
}

