/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.misc;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;

public class IDEACBCPar
extends ASN1Object {
    ASN1OctetString iv;

    public static IDEACBCPar getInstance(Object o) {
        if (o instanceof IDEACBCPar) {
            return (IDEACBCPar)o;
        }
        if (o != null) {
            return new IDEACBCPar(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public IDEACBCPar(byte[] iv) {
        this.iv = new DEROctetString(iv);
    }

    private IDEACBCPar(ASN1Sequence seq) {
        this.iv = seq.size() == 1 ? (ASN1OctetString)seq.getObjectAt(0) : null;
    }

    public byte[] getIV() {
        if (this.iv != null) {
            return Arrays.clone(this.iv.getOctets());
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.iv != null) {
            v.add(this.iv);
        }
        return new DERSequence(v);
    }
}

