/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.ess;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.IssuerSerial;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;

public class ESSCertIDv2
extends ASN1Object {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certHash;
    private IssuerSerial issuerSerial;
    private static final AlgorithmIdentifier DEFAULT_ALG_ID = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);

    public static ESSCertIDv2 getInstance(Object o) {
        if (o instanceof ESSCertIDv2) {
            return (ESSCertIDv2)o;
        }
        if (o != null) {
            return new ESSCertIDv2(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private ESSCertIDv2(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int count = 0;
        this.hashAlgorithm = seq.getObjectAt(0) instanceof ASN1OctetString ? DEFAULT_ALG_ID : AlgorithmIdentifier.getInstance(seq.getObjectAt(count++).toASN1Primitive());
        this.certHash = ASN1OctetString.getInstance(seq.getObjectAt(count++).toASN1Primitive()).getOctets();
        if (seq.size() > count) {
            this.issuerSerial = IssuerSerial.getInstance(seq.getObjectAt(count));
        }
    }

    public ESSCertIDv2(byte[] certHash) {
        this(null, certHash, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash) {
        this(algId, certHash, null);
    }

    public ESSCertIDv2(byte[] certHash, IssuerSerial issuerSerial) {
        this(null, certHash, issuerSerial);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash, IssuerSerial issuerSerial) {
        this.hashAlgorithm = algId == null ? DEFAULT_ALG_ID : algId;
        this.certHash = Arrays.clone(certHash);
        this.issuerSerial = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertHash() {
        return Arrays.clone(this.certHash);
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (!this.hashAlgorithm.equals(DEFAULT_ALG_ID)) {
            v.add(this.hashAlgorithm);
        }
        v.add(new DEROctetString(this.certHash).toASN1Primitive());
        if (this.issuerSerial != null) {
            v.add(this.issuerSerial);
        }
        return new DERSequence(v);
    }
}

