/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.esf;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Choice;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import com.icbc.bcprov.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OtherHash
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString sha1Hash;
    private OtherHashAlgAndValue otherHash;

    public static OtherHash getInstance(Object obj) {
        if (obj instanceof OtherHash) {
            return (OtherHash)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new OtherHash((ASN1OctetString)obj);
        }
        return new OtherHash(OtherHashAlgAndValue.getInstance(obj));
    }

    private OtherHash(ASN1OctetString sha1Hash) {
        this.sha1Hash = sha1Hash;
    }

    public OtherHash(OtherHashAlgAndValue otherHash) {
        this.otherHash = otherHash;
    }

    public OtherHash(byte[] sha1Hash) {
        this.sha1Hash = new DEROctetString(sha1Hash);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        if (null == this.otherHash) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }
        return this.otherHash.getHashAlgorithm();
    }

    public byte[] getHashValue() {
        if (null == this.otherHash) {
            return this.sha1Hash.getOctets();
        }
        return this.otherHash.getHashValue().getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (null == this.otherHash) {
            return this.sha1Hash;
        }
        return this.otherHash.toASN1Primitive();
    }
}

