/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.eac;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ParsingException;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERApplicationSpecific;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.eac.CertificateBody;
import com.icbc.bcprov.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificateRequest
extends ASN1Object {
    private final ASN1ApplicationSpecific original;
    private CertificateBody certificateBody;
    private byte[] innerSignature = null;
    private byte[] outerSignature = null;
    private static final int bodyValid = 1;
    private static final int signValid = 2;

    private CVCertificateRequest(ASN1ApplicationSpecific request) throws IOException {
        this.original = request;
        if (request.isConstructed() && request.getApplicationTag() == 7) {
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getObject(16));
            this.initCertBody(ASN1ApplicationSpecific.getInstance(seq.getObjectAt(0)));
            this.outerSignature = ASN1ApplicationSpecific.getInstance(seq.getObjectAt(seq.size() - 1)).getContents();
        } else {
            this.initCertBody(request);
        }
    }

    private void initCertBody(ASN1ApplicationSpecific request) throws IOException {
        if (request.getApplicationTag() == 33) {
            int valid = 0;
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getObject(16));
            Enumeration en = seq.getObjects();
            block4: while (en.hasMoreElements()) {
                ASN1ApplicationSpecific obj = ASN1ApplicationSpecific.getInstance(en.nextElement());
                switch (obj.getApplicationTag()) {
                    case 78: {
                        this.certificateBody = CertificateBody.getInstance(obj);
                        valid |= 1;
                        continue block4;
                    }
                    case 55: {
                        this.innerSignature = obj.getContents();
                        valid |= 2;
                        continue block4;
                    }
                }
                throw new IOException("Invalid tag, not an CV Certificate Request element:" + obj.getApplicationTag());
            }
            if ((valid & 3) == 0) {
                throw new IOException("Invalid CARDHOLDER_CERTIFICATE in request:" + request.getApplicationTag());
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE in request:" + request.getApplicationTag());
        }
    }

    public static CVCertificateRequest getInstance(Object obj) {
        if (obj instanceof CVCertificateRequest) {
            return (CVCertificateRequest)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificateRequest(ASN1ApplicationSpecific.getInstance(obj));
            }
            catch (IOException e) {
                throw new ASN1ParsingException("unable to parse data: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.certificateBody;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.certificateBody.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return Arrays.clone(this.innerSignature);
    }

    public byte[] getOuterSignature() {
        return Arrays.clone(this.outerSignature);
    }

    public boolean hasOuterSignature() {
        return this.outerSignature != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.original != null) {
            return this.original;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certificateBody);
        try {
            v.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.innerSignature)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, v);
    }
}

