/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1.cmp;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Encodable;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1TaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERTaggedObject;
import com.icbc.bcprov.org.bouncycastle.asn1.cmp.CMPCertificate;
import com.icbc.bcprov.org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.icbc.bcprov.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import java.util.Enumeration;

public class KeyRecRepContent
extends ASN1Object {
    private PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.status = PKIStatusInfo.getInstance(en.nextElement());
        block5: while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en.nextElement());
            switch (tObj.getTagNo()) {
                case 0: {
                    this.newSigCert = CMPCertificate.getInstance(tObj.getObject());
                    continue block5;
                }
                case 1: {
                    this.caCerts = ASN1Sequence.getInstance(tObj.getObject());
                    continue block5;
                }
                case 2: {
                    this.keyPairHist = ASN1Sequence.getInstance(tObj.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + tObj.getTagNo());
        }
    }

    public static KeyRecRepContent getInstance(Object o) {
        if (o instanceof KeyRecRepContent) {
            return (KeyRecRepContent)o;
        }
        if (o != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        if (this.caCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caCerts.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CMPCertificate.getInstance(this.caCerts.getObjectAt(i));
        }
        return results;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        CertifiedKeyPair[] results = new CertifiedKeyPair[this.keyPairHist.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CertifiedKeyPair.getInstance(this.keyPairHist.getObjectAt(i));
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.status);
        this.addOptional(v, 0, this.newSigCert);
        this.addOptional(v, 1, this.caCerts);
        this.addOptional(v, 2, this.keyPairHist);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

