/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DateUtil {
    private static Long ZERO = DateUtil.longValueOf(0L);
    private static final Map localeCache = new HashMap();
    static Locale EN_Locale = DateUtil.forEN();

    DateUtil() {
    }

    private static Locale forEN() {
        if ("en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i != locales.length; ++i) {
            if (!"en".equalsIgnoreCase(locales[i].getLanguage())) continue;
            return locales[i];
        }
        return Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date epochAdjust(Date date) throws ParseException {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return date;
        }
        Map map = localeCache;
        synchronized (map) {
            Long adj = (Long)localeCache.get(locale);
            if (adj == null) {
                SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
                long v = dateF.parse("19700101000000GMT+00:00").getTime();
                adj = v == 0L ? ZERO : DateUtil.longValueOf(v);
                localeCache.put(locale, adj);
            }
            if (adj != ZERO) {
                return new Date(date.getTime() - adj);
            }
            return date;
        }
    }

    private static Long longValueOf(long v) {
        return v;
    }
}

