/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.tsp.cms;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.operator.DigestCalculator;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1String;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.Attributes;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.MetaData;
import java.io.IOException;

class MetaDataUtil {
    private final MetaData metaData;

    MetaDataUtil(MetaData metaData) {
        this.metaData = metaData;
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        if (this.metaData != null && this.metaData.isHashProtected()) {
            try {
                calculator.getOutputStream().write(this.metaData.getEncoded("DER"));
            }
            catch (IOException e) {
                throw new CMSException("unable to initialise calculator from metaData: " + e.getMessage(), e);
            }
        }
    }

    String getFileName() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getFileName());
        }
        return null;
    }

    String getMediaType() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getMediaType());
        }
        return null;
    }

    Attributes getOtherMetaData() {
        if (this.metaData != null) {
            return this.metaData.getOtherMetaData();
        }
        return null;
    }

    private String convertString(ASN1String s) {
        if (s != null) {
            return s.toString();
        }
        return null;
    }
}

