/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkix.jcajce;

import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.AnnotatedException;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.CRLNotFoundException;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.CertStatus;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.PKIXDefaultJcaJceHelper;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.PKIXJcaJceHelper;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.PKIXNamedJcaJceHelper;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.PKIXProviderJcaJceHelper;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.RFC3280CertPathUtilities;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.ReasonsMask;
import com.icbc.bcpkix.org.bouncycastle.pkix.jcajce.RevocationUtilities;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.CRLDistPoint;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.DistributionPoint;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.DistributionPointName;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.Extension;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.GeneralName;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.GeneralNames;
import com.icbc.bcprov.org.bouncycastle.jcajce.PKIXCRLStore;
import com.icbc.bcprov.org.bouncycastle.jcajce.PKIXExtendedParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.util.CollectionStore;
import com.icbc.bcprov.org.bouncycastle.util.Iterable;
import com.icbc.bcprov.org.bouncycastle.util.Selector;
import com.icbc.bcprov.org.bouncycastle.util.Store;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class X509RevocationChecker
extends PKIXCertPathChecker {
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private static Logger LOG = Logger.getLogger(X509RevocationChecker.class.getName());
    private static final Map<GeneralName, WeakReference<X509CRL>> crlCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<X500Principal, Long> failures = new HashMap<X500Principal, Long>();
    private final Set<TrustAnchor> trustAnchors;
    private final boolean isCheckEEOnly;
    private final List<Store<CRL>> crls;
    private final List<CertStore> crlCertStores;
    private final PKIXJcaJceHelper helper;
    private final boolean canSoftFail;
    private final long failLogMaxTime;
    private final long failHardMaxTime;
    private X500Principal workingIssuerName;
    private PublicKey workingPublicKey;
    private X509Certificate signingCert;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    private X509RevocationChecker(Builder bldr) {
        this.crls = new ArrayList<Store<CRL>>(bldr.crls);
        this.crlCertStores = new ArrayList<CertStore>(bldr.crlCertStores);
        this.isCheckEEOnly = bldr.isCheckEEOnly;
        this.trustAnchors = bldr.trustAnchors;
        this.canSoftFail = bldr.canSoftFail;
        this.failLogMaxTime = bldr.failLogMaxTime;
        this.failHardMaxTime = bldr.failHardMaxTime;
        this.helper = bldr.provider != null ? new PKIXProviderJcaJceHelper(bldr.provider) : (bldr.providerName != null ? new PKIXNamedJcaJceHelper(bldr.providerName) : new PKIXDefaultJcaJceHelper());
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new IllegalArgumentException("forward processing not supported");
        }
        this.workingIssuerName = null;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        int i;
        PKIXParameters baseParams;
        X509Certificate cert = (X509Certificate)certificate;
        if (this.isCheckEEOnly && cert.getBasicConstraints() != -1) {
            this.workingIssuerName = cert.getSubjectX500Principal();
            this.workingPublicKey = cert.getPublicKey();
            this.signingCert = cert;
            return;
        }
        TrustAnchor trustAnchor = null;
        if (this.workingIssuerName == null) {
            this.workingIssuerName = cert.getIssuerX500Principal();
            for (TrustAnchor anchor : this.trustAnchors) {
                if (!this.workingIssuerName.equals(anchor.getCA()) && !this.workingIssuerName.equals(anchor.getTrustedCert().getSubjectX500Principal())) continue;
                trustAnchor = anchor;
            }
            if (trustAnchor == null) {
                throw new CertPathValidatorException("no trust anchor found for " + this.workingIssuerName);
            }
            this.signingCert = trustAnchor.getTrustedCert();
            this.workingPublicKey = this.signingCert.getPublicKey();
        }
        ArrayList<X500Principal> issuerList = new ArrayList<X500Principal>();
        try {
            baseParams = new PKIXParameters(this.trustAnchors);
            baseParams.setRevocationEnabled(false);
            baseParams.setDate(new Date());
            for (int i2 = 0; i2 != this.crlCertStores.size(); ++i2) {
                if (LOG.isLoggable(Level.INFO)) {
                    this.addIssuers(issuerList, this.crlCertStores.get(i2));
                }
                baseParams.addCertStore(this.crlCertStores.get(i2));
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("error setting up baseParams: " + e.getMessage());
        }
        PKIXExtendedParameters.Builder pkixParamsBldr = new PKIXExtendedParameters.Builder(baseParams);
        for (i = 0; i != this.crls.size(); ++i) {
            if (LOG.isLoggable(Level.INFO)) {
                this.addIssuers(issuerList, this.crls.get(i));
            }
            pkixParamsBldr.addCRLStore(new LocalCRLStore(this.crls.get(i)));
        }
        if (issuerList.isEmpty()) {
            LOG.log(Level.INFO, "configured with 0 pre-loaded CRLs");
        } else if (LOG.isLoggable(Level.FINE)) {
            for (i = 0; i != issuerList.size(); ++i) {
                LOG.log(Level.FINE, "configuring with CRL for issuer \"" + issuerList.get(i) + "\"");
            }
        } else {
            LOG.log(Level.INFO, "configured with " + issuerList.size() + " pre-loaded CRLs");
        }
        try {
            this.checkCRLs(pkixParamsBldr.build(), cert, baseParams.getDate(), this.signingCert, this.workingPublicKey, new ArrayList(), this.helper);
        }
        catch (AnnotatedException e) {
            throw new CertPathValidatorException(e.getMessage(), e.getCause());
        }
        catch (CRLNotFoundException e) {
            if (cert.getExtensionValue(Extension.cRLDistributionPoints.getId()) != null) {
                CRL crl = null;
                try {
                    crl = this.downloadCRLs(cert.getIssuerX500Principal(), baseParams.getDate(), RevocationUtilities.getExtensionValue(cert, Extension.cRLDistributionPoints), this.helper);
                }
                catch (AnnotatedException e1) {
                    throw new CertPathValidatorException(e.getMessage(), e.getCause());
                }
                if (crl != null) {
                    try {
                        pkixParamsBldr.addCRLStore(new LocalCRLStore(new CollectionStore<CRL>(Collections.singleton(crl))));
                        this.checkCRLs(pkixParamsBldr.build(), cert, new Date(), this.signingCert, this.workingPublicKey, new ArrayList(), this.helper);
                    }
                    catch (AnnotatedException e1) {
                        throw new CertPathValidatorException(e.getMessage(), e.getCause());
                    }
                }
                if (this.canSoftFail) {
                    X500Principal issuer = cert.getIssuerX500Principal();
                    Long initial = this.failures.get(issuer);
                    if (initial != null) {
                        long period = System.currentTimeMillis() - initial;
                        if (this.failHardMaxTime != -1L && this.failHardMaxTime < period) {
                            throw e;
                        }
                        if (period < this.failLogMaxTime) {
                            LOG.log(Level.WARNING, "soft failing for issuer: \"" + issuer + "\"");
                        } else {
                            LOG.log(Level.SEVERE, "soft failing for issuer: \"" + issuer + "\"");
                        }
                    } else {
                        this.failures.put(issuer, System.currentTimeMillis());
                    }
                }
                throw e;
            }
            throw e;
        }
        this.signingCert = cert;
        this.workingPublicKey = cert.getPublicKey();
        this.workingIssuerName = cert.getSubjectX500Principal();
    }

    private void addIssuers(final List<X500Principal> issuerList, CertStore certStore) throws CertStoreException {
        certStore.getCRLs(new X509CRLSelector(){

            @Override
            public boolean match(CRL crl) {
                if (!(crl instanceof X509CRL)) {
                    return false;
                }
                issuerList.add(((X509CRL)crl).getIssuerX500Principal());
                return false;
            }
        });
    }

    private void addIssuers(final List<X500Principal> issuerList, Store<CRL> certStore) {
        certStore.getMatches(new Selector<CRL>(){

            @Override
            public boolean match(CRL crl) {
                if (!(crl instanceof X509CRL)) {
                    return false;
                }
                issuerList.add(((X509CRL)crl).getIssuerX500Principal());
                return false;
            }

            @Override
            public Object clone() {
                return this;
            }
        });
    }

    private CRL downloadCRLs(X500Principal issuer, Date currentDate, ASN1Primitive crlDpPrimitive, JcaJceHelper helper) {
        CRLDistPoint crlDp = CRLDistPoint.getInstance(crlDpPrimitive);
        DistributionPoint[] points = crlDp.getDistributionPoints();
        for (int i = 0; i != points.length; ++i) {
            DistributionPoint dp = points[i];
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn.getType() != 0) continue;
            GeneralName[] names = GeneralNames.getInstance(dpn.getName()).getNames();
            for (int n = 0; n != names.length; ++n) {
                X509CRL crl;
                GeneralName name = names[n];
                if (name.getTagNo() != 6) continue;
                WeakReference<X509CRL> crlRef = crlCache.get(name);
                if (crlRef != null) {
                    crl = (X509CRL)crlRef.get();
                    if (crl != null && !currentDate.before(crl.getThisUpdate()) && !currentDate.after(crl.getNextUpdate())) {
                        return crl;
                    }
                    crlCache.remove(name);
                }
                URL url = null;
                try {
                    url = new URL(name.getName().toString());
                    CertificateFactory certFact = helper.createCertificateFactory("X.509");
                    InputStream urlStream = url.openStream();
                    crl = (X509CRL)certFact.generateCRL(new BufferedInputStream(urlStream));
                    urlStream.close();
                    LOG.log(Level.INFO, "downloaded CRL from CrlDP " + url + " for issuer \"" + issuer + "\"");
                    crlCache.put(name, new WeakReference<X509CRL>(crl));
                    return crl;
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "CrlDP " + url + " ignored: " + e.getMessage(), e);
                        continue;
                    }
                    LOG.log(Level.INFO, "CrlDP " + url + " ignored: " + e.getMessage());
                }
            }
        }
        return null;
    }

    static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, Map<GeneralName, PKIXCRLStore> namedCRLStoreMap) throws AnnotatedException {
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("could not read distribution points could not be read", e);
            }
            ArrayList<PKIXCRLStore> stores = new ArrayList<PKIXCRLStore>();
            for (int i = 0; i < dps.length; ++i) {
                DistributionPointName dpn = dps[i].getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance(dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    PKIXCRLStore store = namedCRLStoreMap.get(genNames[j]);
                    if (store == null) continue;
                    stores.add(store);
                }
            }
            return stores;
        }
        return Collections.EMPTY_LIST;
    }

    protected void checkCRLs(PKIXExtendedParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, List certPathCerts, PKIXJcaJceHelper helper) throws AnnotatedException, CertPathValidatorException {
        AnnotatedException lastException = null;
        CRLDistPoint crldp = null;
        try {
            crldp = CRLDistPoint.getInstance(RevocationUtilities.getExtensionValue(cert, Extension.cRLDistributionPoints));
        }
        catch (Exception e) {
            throw new AnnotatedException("cannot read CRL distribution point extension", e);
        }
        PKIXExtendedParameters.Builder paramsBldr = new PKIXExtendedParameters.Builder(paramsPKIX);
        try {
            List<PKIXCRLStore> extras = X509RevocationChecker.getAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX.getNamedCRLStoreMap());
            Iterator<PKIXCRLStore> it = extras.iterator();
            while (it.hasNext()) {
                paramsBldr.addCRLStore(it.next());
            }
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("no additional CRL locations could be decoded from CRL distribution point extension", e);
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        PKIXExtendedParameters finalParams = paramsBldr.build();
        boolean validCrlFound = false;
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("cannot read distribution points", e);
            }
            if (dps != null) {
                for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                    try {
                        RFC3280CertPathUtilities.checkCRL(dps[i], finalParams, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts, helper);
                        validCrlFound = true;
                        continue;
                    }
                    catch (AnnotatedException e) {
                        lastException = e;
                    }
                }
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                X500Principal issuer = cert.getIssuerX500Principal();
                DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, X500Name.getInstance(issuer.getEncoded())))), null, null);
                PKIXExtendedParameters paramsPKIXClone = (PKIXExtendedParameters)paramsPKIX.clone();
                RFC3280CertPathUtilities.checkCRL(dp, paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts, helper);
                validCrlFound = true;
            }
            catch (AnnotatedException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            if (lastException instanceof AnnotatedException) {
                throw new CRLNotFoundException("no valid CRL found", lastException);
            }
            throw new CRLNotFoundException("no valid CRL found");
        }
        if (certStatus.getCertStatus() != 11) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            String message = "certificate [issuer=\"" + cert.getIssuerX500Principal() + "\",serialNumber=" + cert.getSerialNumber() + ",subject=\"" + cert.getSubjectX500Principal() + "\"] revoked after " + df.format(certStatus.getRevocationDate());
            message = message + ", reason: " + crlReasons[certStatus.getCertStatus()];
            throw new AnnotatedException(message);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new AnnotatedException("certificate status could not be determined");
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    private class LocalCRLStore<T extends CRL>
    implements PKIXCRLStore,
    Iterable<CRL> {
        private Collection<CRL> _local;

        public LocalCRLStore(Store<CRL> collection) {
            this._local = new ArrayList<CRL>(collection.getMatches(null));
        }

        @Override
        public Collection getMatches(Selector selector) {
            if (selector == null) {
                return new ArrayList<CRL>(this._local);
            }
            ArrayList<CRL> col = new ArrayList<CRL>();
            for (CRL obj : this._local) {
                if (!selector.match(obj)) continue;
                col.add(obj);
            }
            return col;
        }

        @Override
        public Iterator<CRL> iterator() {
            return this.getMatches((Selector)null).iterator();
        }
    }

    public static class Builder {
        private Set<TrustAnchor> trustAnchors;
        private List<CertStore> crlCertStores = new ArrayList<CertStore>();
        private List<Store<CRL>> crls = new ArrayList<Store<CRL>>();
        private boolean isCheckEEOnly;
        private int validityModel = 0;
        private Provider provider;
        private String providerName;
        private boolean canSoftFail;
        private long failLogMaxTime;
        private long failHardMaxTime;

        public Builder(TrustAnchor trustAnchor) {
            this.trustAnchors = Collections.singleton(trustAnchor);
        }

        public Builder(Set<TrustAnchor> trustAnchors) {
            this.trustAnchors = new HashSet<TrustAnchor>(trustAnchors);
        }

        public Builder(KeyStore trustStore) throws KeyStoreException {
            this.trustAnchors = new HashSet<TrustAnchor>();
            Enumeration<String> en = trustStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!trustStore.isCertificateEntry(alias)) continue;
                this.trustAnchors.add(new TrustAnchor((X509Certificate)trustStore.getCertificate(alias), null));
            }
        }

        public Builder addCrls(CertStore crls) {
            this.crlCertStores.add(crls);
            return this;
        }

        public Builder addCrls(Store<CRL> crls) {
            this.crls.add(crls);
            return this;
        }

        public Builder setCheckEndEntityOnly(boolean isTrue) {
            this.isCheckEEOnly = isTrue;
            return this;
        }

        public Builder setSoftFail(boolean isTrue, long maxTime) {
            this.canSoftFail = isTrue;
            this.failLogMaxTime = maxTime;
            this.failHardMaxTime = -1L;
            return this;
        }

        public Builder setSoftFailHardLimit(boolean isTrue, long maxTime) {
            this.canSoftFail = isTrue;
            this.failLogMaxTime = maxTime * 3L / 4L;
            this.failHardMaxTime = maxTime;
            return this;
        }

        public Builder usingProvider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder usingProvider(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public X509RevocationChecker build() {
            return new X509RevocationChecker(this);
        }
    }
}

