/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs.jcajce;

import com.icbc.bcpkix.org.bouncycastle.operator.GenericKey;
import com.icbc.bcpkix.org.bouncycastle.operator.MacCalculator;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.DERNull;
import com.icbc.bcprov.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.jcajce.PKCS12Key;
import com.icbc.bcprov.org.bouncycastle.jcajce.io.MacOutputStream;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public JcePKCS12MacCalculatorBuilder() {
        this(OIWObjectIdentifiers.idSHA1);
    }

    public JcePKCS12MacCalculatorBuilder(ASN1ObjectIdentifier hashAlgorithm) {
        this.algorithm = hashAlgorithm;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE);
    }

    @Override
    public MacCalculator build(char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            final Mac mac = this.helper.createMac(this.algorithm.getId());
            this.saltLength = mac.getMacLength();
            final byte[] salt = new byte[this.saltLength];
            this.random.nextBytes(salt);
            PBEParameterSpec defParams = new PBEParameterSpec(salt, this.iterationCount);
            final PKCS12Key key = new PKCS12Key(password);
            mac.init(key, defParams);
            return new MacCalculator(){

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(JcePKCS12MacCalculatorBuilder.this.algorithm, new PKCS12PBEParams(salt, JcePKCS12MacCalculatorBuilder.this.iterationCount));
                }

                @Override
                public OutputStream getOutputStream() {
                    return new MacOutputStream(mac);
                }

                @Override
                public byte[] getMac() {
                    return mac.doFinal();
                }

                @Override
                public GenericKey getKey() {
                    return new GenericKey(this.getAlgorithmIdentifier(), key.getEncoded());
                }
            };
        }
        catch (Exception e) {
            throw new OperatorCreationException("unable to create MAC calculator: " + e.getMessage(), e);
        }
    }
}

