/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs.bc;

import com.icbc.bcpkix.org.bouncycastle.operator.GenericKey;
import com.icbc.bcpkix.org.bouncycastle.operator.InputDecryptor;
import com.icbc.bcpkix.org.bouncycastle.operator.InputDecryptorProvider;
import com.icbc.bcpkix.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.io.CipherInputStream;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

