/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs.bc;

import com.icbc.bcpkix.org.bouncycastle.operator.MacCalculator;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcDigestProvider;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.icbc.bcpkix.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import com.icbc.bcprov.org.bouncycastle.asn1.DERNull;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

