/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CRLHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.operator.OutputEncryptor;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12SafeBag;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Encodable;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSet;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.Attribute;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.CertBag;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.SafeBag;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.Certificate;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.CertificateList;
import java.io.IOException;

public class PKCS12SafeBagBuilder {
    private ASN1ObjectIdentifier bagType;
    private ASN1Encodable bagValue;
    private ASN1EncodableVector bagAttrs = new ASN1EncodableVector();

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo, OutputEncryptor encryptor) {
        this.bagType = PKCSObjectIdentifiers.pkcs8ShroudedKeyBag;
        this.bagValue = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo).build(encryptor).toASN1Structure();
    }

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo) {
        this.bagType = PKCSObjectIdentifiers.keyBag;
        this.bagValue = privateKeyInfo;
    }

    public PKCS12SafeBagBuilder(X509CertificateHolder certificate) throws IOException {
        this(certificate.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(X509CRLHolder crl) throws IOException {
        this(crl.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(Certificate certificate) throws IOException {
        this.bagType = PKCSObjectIdentifiers.certBag;
        this.bagValue = new CertBag(PKCSObjectIdentifiers.x509Certificate, new DEROctetString(certificate.getEncoded()));
    }

    public PKCS12SafeBagBuilder(CertificateList crl) throws IOException {
        this.bagType = PKCSObjectIdentifiers.crlBag;
        this.bagValue = new CertBag(PKCSObjectIdentifiers.x509Crl, new DEROctetString(crl.getEncoded()));
    }

    public PKCS12SafeBagBuilder addBagAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        this.bagAttrs.add(new Attribute(attrType, new DERSet(attrValue)));
        return this;
    }

    public PKCS12SafeBag build() {
        return new PKCS12SafeBag(new SafeBag(this.bagType, this.bagValue, new DERSet(this.bagAttrs)));
    }
}

