/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs;

import com.icbc.bcpkix.org.bouncycastle.pkcs.MacDataGenerator;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCSException;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCSIOException;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.ContentInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.MacData;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.Pfx;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx pfx;

    private static Pfx parseBytes(byte[] pfxEncoding) throws IOException {
        try {
            return Pfx.getInstance(ASN1Primitive.fromByteArray(pfxEncoding));
        }
        catch (ClassCastException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public PKCS12PfxPdu(byte[] pfx) throws IOException {
        this(PKCS12PfxPdu.parseBytes(pfx));
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] content = new ContentInfo[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            content[i] = ContentInfo.getInstance(seq.getObjectAt(i));
        }
        return content;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public AlgorithmIdentifier getMacAlgorithmID() {
        MacData md = this.pfx.getMacData();
        if (md != null) {
            return md.getMac().getAlgorithmId();
        }
        return null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider macCalcProviderBuilder, char[] password) throws PKCSException {
        if (this.hasMac()) {
            MacData pfxmData = this.pfx.getMacData();
            MacDataGenerator mdGen = new MacDataGenerator(macCalcProviderBuilder.get(new AlgorithmIdentifier(pfxmData.getMac().getAlgorithmId().getAlgorithm(), new PKCS12PBEParams(pfxmData.getSalt(), pfxmData.getIterationCount().intValue()))));
            try {
                MacData mData = mdGen.build(password, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(mData.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException e) {
                throw new PKCSException("unable to process AuthSafe: " + e.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }

    public byte[] getEncoded() throws IOException {
        return this.toASN1Structure().getEncoded();
    }

    public byte[] getEncoded(String encoding) throws IOException {
        return this.toASN1Structure().getEncoded(encoding);
    }
}

