/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs;

import com.icbc.bcpkix.org.bouncycastle.operator.MacCalculator;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCSException;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.MacData;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.DigestInfo;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder builder) {
        this.builder = builder;
    }

    public MacData build(char[] password, byte[] data) throws PKCSException {
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(password);
            OutputStream out = macCalculator.getOutputStream();
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            throw new PKCSException("unable to process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier algId = macCalculator.getAlgorithmIdentifier();
        DigestInfo dInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
        return new MacData(dInfo, params.getIV(), params.getIterations().intValue());
    }
}

