/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.operator.jcajce;

import com.icbc.bcpkix.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import com.icbc.bcpkix.org.bouncycastle.operator.GenericKey;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorException;
import com.icbc.bcpkix.org.bouncycastle.operator.jcajce.JceGenericKey;
import com.icbc.bcpkix.org.bouncycastle.operator.jcajce.OperatorHelper;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.GenericHybridParameters;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.RsaKemParameters;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.util.DEROtherInfo;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.KTSParameterSpec;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class JceKTSKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;
    private byte[] partyUInfo;
    private byte[] partyVInfo;

    public JceKTSKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey, byte[] partyUInfo, byte[] partyVInfo) {
        super(algorithmIdentifier);
        this.privKey = privKey;
        this.partyUInfo = Arrays.clone(partyUInfo);
        this.partyVInfo = Arrays.clone(partyVInfo);
    }

    public JceKTSKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        Key sKey;
        GenericHybridParameters params = GenericHybridParameters.getInstance(this.getAlgorithmIdentifier().getParameters());
        Cipher keyCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        String symmetricWrappingAlg = this.helper.getWrappingAlgorithmName(params.getDem().getAlgorithm());
        RsaKemParameters kemParameters = RsaKemParameters.getInstance(params.getKem().getParameters());
        int keySizeInBits = kemParameters.getKeyLength().intValue() * 8;
        try {
            DEROtherInfo otherInfo = new DEROtherInfo.Builder(params.getDem(), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(symmetricWrappingAlg, keySizeInBits, otherInfo.getEncoded()).withKdfAlgorithm(kemParameters.getKeyDerivationFunction()).build();
            keyCipher.init(4, (Key)this.privKey, ktsSpec);
            sKey = keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3);
        }
        catch (Exception e) {
            throw new OperatorException("Unable to unwrap contents key: " + e.getMessage(), e);
        }
        return new JceGenericKey(encryptedKeyAlgorithm, sKey);
    }
}

