/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.operator.bc;

import com.icbc.bcpkix.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.Signer;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.DSADigestSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.ECDSASigner;
import com.icbc.bcprov.org.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.IOException;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSADigestSigner(new ECDSASigner(), dig);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

