/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.openssl.jcajce;

import com.icbc.bcpkix.org.bouncycastle.openssl.PEMEncryptor;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMException;
import com.icbc.bcpkix.org.bouncycastle.openssl.jcajce.PEMUtilities;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import java.security.Provider;
import java.security.SecureRandom;

public class JcePEMEncryptorBuilder {
    private final String algorithm;
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private SecureRandom random;

    public JcePEMEncryptorBuilder(String algorithm) {
        this.algorithm = algorithm;
    }

    public JcePEMEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMEncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePEMEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PEMEncryptor build(final char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        int ivLength = this.algorithm.startsWith("AES-") ? 16 : 8;
        final byte[] iv = new byte[ivLength];
        this.random.nextBytes(iv);
        return new PEMEncryptor(){

            @Override
            public String getAlgorithm() {
                return JcePEMEncryptorBuilder.this.algorithm;
            }

            @Override
            public byte[] getIV() {
                return iv;
            }

            @Override
            public byte[] encrypt(byte[] encoding) throws PEMException {
                return PEMUtilities.crypt(true, JcePEMEncryptorBuilder.this.helper, encoding, password, JcePEMEncryptorBuilder.this.algorithm, iv);
            }
        };
    }
}

