/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.openssl;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.openssl.CertificateTrustBlock;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1InputStream;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class X509TrustedCertificateBlock {
    private final X509CertificateHolder certificateHolder;
    private final CertificateTrustBlock trustBlock;

    public X509TrustedCertificateBlock(X509CertificateHolder certificateHolder, CertificateTrustBlock trustBlock) {
        this.certificateHolder = certificateHolder;
        this.trustBlock = trustBlock;
    }

    public X509TrustedCertificateBlock(byte[] encoding) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        this.certificateHolder = new X509CertificateHolder(aIn.readObject().getEncoded());
        ASN1Primitive tBlock = aIn.readObject();
        this.trustBlock = tBlock != null ? new CertificateTrustBlock(tBlock.getEncoded()) : null;
    }

    public byte[] getEncoded() throws IOException {
        return Arrays.concatenate(this.certificateHolder.getEncoded(), this.trustBlock.toASN1Sequence().getEncoded());
    }

    public X509CertificateHolder getCertificateHolder() {
        return this.certificateHolder;
    }

    public CertificateTrustBlock getTrustBlock() {
        return this.trustBlock;
    }
}

