/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.openssl;

import com.icbc.bcpkix.org.bouncycastle.openssl.PEMDecryptor;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMDecryptorProvider;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMException;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMKeyPair;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMKeyPairParser;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import java.io.IOException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor keyDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(keyDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException e) {
            throw e;
        }
        catch (OperatorCreationException e) {
            throw new PEMException("cannot create extraction operator: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PEMException("exception processing key pair: " + e.getMessage(), e);
        }
    }
}

