/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.mozilla.jcajce;

import com.icbc.bcpkix.org.bouncycastle.mozilla.SignedPublicKeyAndChallenge;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.icbc.bcprov.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class JcaSignedPublicKeyAndChallenge
extends SignedPublicKeyAndChallenge {
    JcaJceHelper helper = new DefaultJcaJceHelper();

    private JcaSignedPublicKeyAndChallenge(com.icbc.bcprov.org.bouncycastle.asn1.mozilla.SignedPublicKeyAndChallenge struct, JcaJceHelper helper) {
        super(struct);
        this.helper = helper;
    }

    public JcaSignedPublicKeyAndChallenge(byte[] bytes) {
        super(bytes);
    }

    public JcaSignedPublicKeyAndChallenge setProvider(String providerName) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new NamedJcaJceHelper(providerName));
    }

    public JcaSignedPublicKeyAndChallenge setProvider(Provider provider) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new ProviderJcaJceHelper(provider));
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = this.spkacSeq.getPublicKeyAndChallenge().getSubjectPublicKeyInfo();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            AlgorithmIdentifier keyAlg = subjectPublicKeyInfo.getAlgorithm();
            KeyFactory factory = this.helper.createKeyFactory(keyAlg.getAlgorithm().getId());
            return factory.generatePublic(xspec);
        }
        catch (Exception e) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

