/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.dvcs;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.dvcs.DVCSException;
import com.icbc.bcpkix.org.bouncycastle.dvcs.DVCSRequest;
import com.icbc.bcpkix.org.bouncycastle.dvcs.DVCSRequestBuilder;
import com.icbc.bcpkix.org.bouncycastle.dvcs.TargetChain;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.CertEtcToken;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSTime;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.Data;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.ServiceType;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.Extension;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder cert) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, cert.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date requestTime) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(requestTime));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

