/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.dvcs;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSSignedData;
import com.icbc.bcpkix.org.bouncycastle.dvcs.DVCSConstructionException;
import com.icbc.bcpkix.org.bouncycastle.dvcs.DVCSMessage;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Encodable;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.ContentInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.SignedData;
import com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;

public class DVCSResponse
extends DVCSMessage {
    private com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : com.icbc.bcprov.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

