/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cms.jcajce;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.RecipientOperator;
import com.icbc.bcpkix.org.bouncycastle.cms.jcajce.JcePasswordRecipient;
import com.icbc.bcpkix.org.bouncycastle.operator.GenericKey;
import com.icbc.bcpkix.org.bouncycastle.operator.MacCalculator;
import com.icbc.bcpkix.org.bouncycastle.operator.jcajce.JceGenericKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.jcajce.io.MacOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;

public class JcePasswordAuthenticatedRecipient
extends JcePasswordRecipient {
    public JcePasswordAuthenticatedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentMacAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        final Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentMacAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Mac dataMac = this.helper.createContentMac(secretKey, contentMacAlgorithm);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentMacAlgorithm;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(contentMacAlgorithm, secretKey);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(dataMac);
            }

            @Override
            public byte[] getMac() {
                return dataMac.doFinal();
            }
        });
    }
}

