/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cms;

import com.icbc.bcpkix.org.bouncycastle.cms.AuthAttributesProvider;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSSecureReadable;
import com.icbc.bcpkix.org.bouncycastle.cms.KEKRecipient;
import com.icbc.bcpkix.org.bouncycastle.cms.KEKRecipientId;
import com.icbc.bcpkix.org.bouncycastle.cms.Recipient;
import com.icbc.bcpkix.org.bouncycastle.cms.RecipientInformation;
import com.icbc.bcpkix.org.bouncycastle.cms.RecipientOperator;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.KEKIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

