/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cms;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSContentInfoParser;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSTypedStream;
import com.icbc.bcpkix.org.bouncycastle.operator.InputExpander;
import com.icbc.bcpkix.org.bouncycastle.operator.InputExpanderProvider;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetStringParser;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1SequenceParser;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.CompressedDataParser;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.ContentInfoParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] compressedData) throws CMSException {
        this(new ByteArrayInputStream(compressedData));
    }

    public CMSCompressedDataParser(InputStream compressedData) throws CMSException {
        super(compressedData);
    }

    public CMSTypedStream getContent(InputExpanderProvider expanderProvider) throws CMSException {
        try {
            CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser content = comData.getEncapContentInfo();
            InputExpander expander = expanderProvider.get(comData.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
            return new CMSTypedStream(content.getContentType().getId(), expander.getInputStream(bytes.getOctetStream()));
        }
        catch (IOException e) {
            throw new CMSException("IOException reading compressed content.", e);
        }
    }
}

