/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cms;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSEnvelopedHelper;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSSecureReadable;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSUtils;
import com.icbc.bcpkix.org.bouncycastle.cms.RecipientInformationStore;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Set;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.ContentInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.OriginatorInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;

class CMSAuthEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInfo originator;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(InputStream authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        this.originator = authEnvData.getOriginatorInfo();
        ASN1Set recipientInfos = authEnvData.getRecipientInfos();
        EncryptedContentInfo authEncInfo = authEnvData.getAuthEncryptedContentInfo();
        this.authEncAlg = authEncInfo.getContentEncryptionAlgorithm();
        CMSSecureReadable secureReadable = new CMSSecureReadable(){

            @Override
            public InputStream getInputStream() throws IOException, CMSException {
                return null;
            }
        };
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.authEncAlg, secureReadable);
        this.authAttrs = authEnvData.getAuthAttrs();
        this.mac = authEnvData.getMac().getOctets();
        this.unauthAttrs = authEnvData.getUnauthAttrs();
    }
}

