/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cert.path.validations;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CRLHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidation;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidationContext;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidationException;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.util.Memoable;
import com.icbc.bcprov.org.bouncycastle.util.Selector;
import com.icbc.bcprov.org.bouncycastle.util.Store;
import java.util.Collection;

public class CRLValidation
implements CertPathValidation {
    private Store crls;
    private X500Name workingIssuerName;

    public CRLValidation(X500Name trustAnchorName, Store crls) {
        this.workingIssuerName = trustAnchorName;
        this.crls = crls;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        Collection matches = this.crls.getMatches(new Selector(){

            public boolean match(Object obj) {
                X509CRLHolder crl = (X509CRLHolder)obj;
                return crl.getIssuer().equals(CRLValidation.this.workingIssuerName);
            }

            @Override
            public Object clone() {
                return this;
            }
        });
        if (matches.isEmpty()) {
            throw new CertPathValidationException("CRL for " + this.workingIssuerName + " not found");
        }
        for (X509CRLHolder crl : matches) {
            if (crl.getRevokedCertificate(certificate.getSerialNumber()) == null) continue;
            throw new CertPathValidationException("Certificate revoked");
        }
        this.workingIssuerName = certificate.getSubject();
    }

    @Override
    public Memoable copy() {
        return new CRLValidation(this.workingIssuerName, this.crls);
    }

    @Override
    public void reset(Memoable other) {
        CRLValidation v = (CRLValidation)other;
        this.workingIssuerName = v.workingIssuerName;
        this.crls = v.crls;
    }
}

