/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cert.crmf.bc;

import com.icbc.bcpkix.org.bouncycastle.cert.crmf.CRMFException;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherKeyGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import com.icbc.bcprov.org.bouncycastle.crypto.util.CipherFactory;
import com.icbc.bcprov.org.bouncycastle.crypto.util.CipherKeyGeneratorFactory;
import java.security.SecureRandom;

class CRMFHelper {
    CRMFHelper() {
    }

    CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier algorithm, SecureRandom random) throws CRMFException {
        try {
            return CipherKeyGeneratorFactory.createKeyGenerator(algorithm, random);
        }
        catch (IllegalArgumentException e) {
            throw new CRMFException(e.getMessage(), e);
        }
    }

    static Object createContentCipher(boolean forEncryption, CipherParameters encKey, AlgorithmIdentifier encryptionAlgID) throws CRMFException {
        try {
            return CipherFactory.createContentCipher(forEncryption, encKey, encryptionAlgID);
        }
        catch (IllegalArgumentException e) {
            throw new CRMFException(e.getMessage(), e);
        }
    }

    AlgorithmIdentifier generateEncryptionAlgID(ASN1ObjectIdentifier encryptionOID, KeyParameter encKey, SecureRandom random) throws CRMFException {
        try {
            return AlgorithmIdentifierFactory.generateEncryptionAlgID(encryptionOID, encKey.getKey().length * 8, random);
        }
        catch (IllegalArgumentException e) {
            throw new CRMFException(e.getMessage(), e);
        }
    }
}

