/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cert.crmf;

import com.icbc.bcpkix.org.bouncycastle.cert.crmf.PKIArchiveControl;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSEnvelopedData;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSProcessableByteArray;
import com.icbc.bcpkix.org.bouncycastle.cms.RecipientInfoGenerator;
import com.icbc.bcpkix.org.bouncycastle.operator.OutputEncryptor;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.EnvelopedData;
import com.icbc.bcprov.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.crmf.EncKeyWithID;
import com.icbc.bcprov.org.bouncycastle.asn1.crmf.EncryptedKey;
import com.icbc.bcprov.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.GeneralName;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

